import os
import sys
import gzip
from Bio import SeqIO

library = sys.argv[1]

directory = "/osc-fs_home/mdehoon/Data/CASPARs/CAGE/Fasta/"
filename = "%s.fa.gz" % library
path = os.path.join(directory, filename)

sequences = {}
print("Reading", path)
stream = gzip.open(path, "rt")
records = SeqIO.parse(stream, "fasta")
for record in records:
    name = record.id
    sequence = str(record.seq)
    sequences[name] = sequence
stream.close()

print("Sorting")
names = sorted(sequences.keys(), key=lambda name: tuple(map(int, name.split(":")[-3:])))

filename = "%s.fa" % library
print("Writing", filename)
stream = open(filename, 'wt')
for name in names:
    stream.write(">%s\n" % name)
    stream.write(sequences[name] + "\n")
stream.close()
